/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.data;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.CEComment;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUAdditional;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUNew;
import com.ibm.hsc.auiml.databeans.sfp.data.FRUOriginal;
import com.ibm.hsc.auiml.databeans.sfp.data.ManagedObject;
import com.ibm.hsc.auiml.databeans.sfp.data.ServiceableEventListener;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.rsct.rmc.McResource;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.rmcjni.McErrNumException;
import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtRsrcHandle;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CtUint32;
import com.ibm.rsct.util.CuException;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class ServiceableEvent
implements Serializable {
    private ManagedObject[] managedObjects = null;
    private CEComment[] ceComments = null;
    private FRUOriginal[] fruListOriginal = null;
    private FRUAdditional[] fruListAdditional = null;
    private int changeCounter = -1;
    private String hscId = "";
    private String hscName = "";
    private String status = "";
    private String errLogLabel = "";
    private boolean callHomeCandidate = false;
    private boolean calledHome = false;
    private CEComment ceCommentsNew = null;
    private FRUNew fruNew = null;
    private String ptrHscEED = "";
    private String earliestOriginalTimestamp = "";
    private String latestTimestamp = "";
    private Locale hmcLocale = null;
    private int variety = -1;
    private String componentId = "";
    private String specialHandling = "";
    private CtRsrcHandle resourceHandle = null;
    private Vector listeners = new Vector();
    private static final int ID_RESOURCE_HANDLE = 0;
    private static final int ID_CHANGE_COUNTER = 1;
    private static final int ID_HSC_ID = 2;
    private static final int ID_HSC_NAME = 3;
    private static final String ATTRIBUTE_STATUS = "Status";
    private static final int ID_STATUS = 4;
    private static final int ID_ERR_LOG_LABEL = 5;
    private static final int ID_CALL_HOME_CANDIDATE = 6;
    private static final int ID_CALLED_HOME = 7;
    private static final int ID_CE_COMMENTS = 8;
    private static final String ATTRIBUTE_CE_COMMENTS_NEW = "CECommentsNew";
    private static final int ID_CE_COMMENTS_NEW = 9;
    private static final int ID_FRU_LIST = 10;
    private static final int ID_FRU_LIST_ADDITIONAL = 11;
    private static final String ATTRIBUTE_FRU_NEW = "FRUListNew";
    private static final int ID_FRU_NEW = 12;
    private static final int ID_PTR_HSC_EED = 13;
    private static final int ID_MANAGED_OBJECTS = 14;
    private static final int ID_VARIETY = 15;
    private static final int ID_NODE_LIST = 16;
    private static final int ID_COMPONENT_ID = 17;
    private static final int ID_SPECIAL_HANDLING = 18;
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String OPEN = "Open";
    public static final String CLOSED = "Closed";
    public static final int HIGHEST_UNDERSTOOD_VARIETY = 3;
    public static final String SURVEILLANCE_ERROR_CLASS = "SURVALNC";
    public static final String CUSTOMER_UPGRADE_ON_DEMAND_ERROR_CLASS = "CUOD";
    private static final String TRACE_MASKD = "JSEVENTD";
    private static final String TRACE_MASKF = "JSEVENTF";
    private static final String TRACE_MASKT = "JSEVENTT";
    private static final ClassLogInfo _logInfo = new ClassLogInfo(-88, 108, "SFPSvcbleEvt");
    private static final short ERRID_0080 = 128;

    public ServiceableEvent(McResource mcResource) throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.c-tor()");
        }
        this.hmcLocale = Locale.getDefault();
        this.parseAttributes(mcResource);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.c-tor()");
        }
    }

    private synchronized void parseAttributes(McResource mcResource) throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseAttributes(McResource)");
        }
        if (mcResource != null) {
            McAttribute[] mcAttributeArray = null;
            Exception exception = null;
            try {
                mcAttributeArray = mcResource.getAllPersistentAttributes();
            }
            catch (McErrNumException mcErrNumException) {
                exception = new Exception(mcErrNumException.getMessage());
            }
            catch (CuException cuException) {
                exception = new Exception(cuException.getMessage());
            }
            if (exception != null) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "ServiceableEvent.parseAttributes() caught: " + exception);
                }
                throw new SFPException("0001", exception);
            }
            this.parseAttributes(mcAttributeArray);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseAttributes(McResource)");
        }
    }

    private synchronized void parseAttributes(McAttribute[] mcAttributeArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseAttributes(McAttribute[])");
        }
        if (mcAttributeArray != null) {
            try {
                block22: for (int i = 0; i < mcAttributeArray.length; ++i) {
                    McAttribute mcAttribute = mcAttributeArray[i];
                    switch (mcAttribute.getId()) {
                        case 0: {
                            this.resourceHandle = ServiceableEvent.getResourceHandleAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 1: {
                            this.changeCounter = ServiceableEvent.getIntegerAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 2: {
                            this.hscId = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 3: {
                            this.hscName = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 4: {
                            this.status = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 5: {
                            this.errLogLabel = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 6: {
                            this.callHomeCandidate = ServiceableEvent.getBooleanAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 7: {
                            this.calledHome = ServiceableEvent.getIntegerAttributeValue(mcAttribute) > 0;
                            continue block22;
                        }
                        case 8: {
                            this.parseCEComments(mcAttribute);
                            continue block22;
                        }
                        case 9: {
                            this.ceCommentsNew = new CEComment(ServiceableEvent.getStructuredDataAttributeValue(mcAttribute));
                            continue block22;
                        }
                        case 10: {
                            this.parseFRUListOriginal(mcAttribute);
                            continue block22;
                        }
                        case 11: {
                            this.parseFRUListAdditional(mcAttribute);
                            continue block22;
                        }
                        case 12: {
                            this.fruNew = new FRUNew(ServiceableEvent.getStructuredDataAttributeValue(mcAttribute));
                            continue block22;
                        }
                        case 13: {
                            this.ptrHscEED = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 14: {
                            this.parseManagedObjects(mcAttribute);
                            continue block22;
                        }
                        case 15: {
                            this.variety = ServiceableEvent.getIntegerAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 17: {
                            this.componentId = ServiceableEvent.getStringAttributeValue(mcAttribute);
                            continue block22;
                        }
                        case 18: {
                            this.specialHandling = ServiceableEvent.getStringAttributeValue(mcAttribute);
                        }
                    }
                }
                this.parseTimestamps();
                this.notifyListeners();
            }
            catch (RuntimeException runtimeException) {
                new AusMicrocodeLog(_logInfo, 128, runtimeException).writeEntry(null);
                throw runtimeException;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseAttributes(McAttribute[])");
        }
    }

    public void reset(McResource mcResource) throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.reset(McResource)");
        }
        this.parseAttributes(mcResource);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.reset(McResource)");
        }
    }

    private void reset(ServiceableEvent serviceableEvent) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.reset(ServiceableEvent)");
        }
        if (serviceableEvent != null) {
            this.resourceHandle = serviceableEvent.getResourceHandle();
            this.changeCounter = serviceableEvent.getChangeCounter();
            this.hscId = serviceableEvent.getHSCId();
            this.hscName = serviceableEvent.getHSCName();
            this.status = serviceableEvent.getStatus();
            this.errLogLabel = serviceableEvent.getErrLogLabel();
            this.callHomeCandidate = serviceableEvent.isCallHomeCandidate();
            this.calledHome = serviceableEvent.isCalledHome();
            this.ceComments = serviceableEvent.getCEComments();
            this.ceCommentsNew = serviceableEvent.getCECommentsNew();
            this.fruListOriginal = serviceableEvent.getFRUListOriginal();
            this.fruListAdditional = serviceableEvent.getFRUListAdditional();
            this.fruNew = serviceableEvent.getFRUNew();
            this.ptrHscEED = serviceableEvent.getPtrHscEED();
            this.managedObjects = serviceableEvent.getManagedObjects();
            this.earliestOriginalTimestamp = serviceableEvent.getEarliestOriginalTimestamp();
            this.latestTimestamp = serviceableEvent.getLatestTimestamp();
            this.variety = serviceableEvent.getVariety();
            this.componentId = serviceableEvent.getComponentId();
            this.specialHandling = serviceableEvent.getSpecialHandling();
            this.notifyListeners();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.reset(ServiceableEvent)");
        }
    }

    public CtRsrcHandle getResourceHandle() {
        return this.resourceHandle;
    }

    public int getChangeCounter() {
        return this.changeCounter;
    }

    public String getHSCId() {
        return this.hscId;
    }

    public String getHSCName() {
        return this.hscName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isOpen() {
        return OPEN.equalsIgnoreCase(this.status);
    }

    public String getErrLogLabel() {
        return this.errLogLabel;
    }

    public boolean isCallHomeCandidate() {
        return this.callHomeCandidate;
    }

    public boolean isCalledHome() {
        return this.calledHome;
    }

    public CEComment[] getCEComments() {
        return this.ceComments;
    }

    public CEComment getCECommentsNew() {
        return this.ceCommentsNew;
    }

    public FRUOriginal[] getFRUListOriginal() {
        return this.fruListOriginal;
    }

    public FRUAdditional[] getFRUListAdditional() {
        return this.fruListAdditional;
    }

    public FRUNew getFRUNew() {
        return this.fruNew;
    }

    public String getPtrHscEED() {
        return this.ptrHscEED;
    }

    public ManagedObject[] getManagedObjects() {
        return this.managedObjects;
    }

    public Locale getHMCLocale() {
        return this.hmcLocale;
    }

    public int getVariety() {
        return this.variety;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getSpecialHandling() {
        return this.specialHandling;
    }

    public boolean isFullyParsed() {
        return this.getVariety() <= 3;
    }

    public String getEarliestOriginalTimestamp() {
        return this.earliestOriginalTimestamp;
    }

    public String getLatestTimestamp() {
        return this.latestTimestamp;
    }

    private void parseTimestamps() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseTimestamps()");
        }
        ManagedObject[] managedObjectArray = this.getManagedObjects();
        Date date = null;
        Date date2 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject managedObject = managedObjectArray[i];
            Date date3 = managedObject.getOrigTimestampDate();
            Date date4 = managedObject.getLastTimestampDate();
            if (date4 == null) {
                date4 = date3;
            }
            if (date == null || date3 != null && date3.before(date)) {
                date = date3;
                n = i;
            }
            if (date2 != null && (date4 == null || !date4.after(date2))) continue;
            date2 = date4;
            n2 = i;
        }
        String string = this.earliestOriginalTimestamp = n > -1 ? managedObjectArray[n].getOrigTimestamp() : "";
        if (n2 == -1) {
            this.latestTimestamp = "";
        } else {
            this.latestTimestamp = managedObjectArray[n2].getLastTimestamp();
            if (this.latestTimestamp == null || this.latestTimestamp.length() == 0) {
                this.latestTimestamp = managedObjectArray[n2].getOrigTimestamp();
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseTimestamps()");
        }
    }

    private void parseManagedObjects(McAttribute mcAttribute) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseManagedObjects()");
        }
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.managedObjects = new ManagedObject[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.managedObjects[i] = new ManagedObject((CtStructuredData)ctDataTypeArray[i], this.hmcLocale);
                continue;
            }
            catch (ClassCastException classCastException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "ServiceableEvent.parseManagedObjects() expecting CtStructuredData: " + classCastException);
                }
                throw classCastException;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseManagedObjects()");
        }
    }

    private void parseCEComments(McAttribute mcAttribute) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseCEComments()");
        }
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.ceComments = new CEComment[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.ceComments[i] = new CEComment((CtStructuredData)ctDataTypeArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "ServiceableEvent.parseCEComments() expecting CtStructuredData: " + classCastException);
                }
                throw classCastException;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseCEComments()");
        }
    }

    private void parseFRUListOriginal(McAttribute mcAttribute) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseFRUListOriginal()");
        }
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.fruListOriginal = new FRUOriginal[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.fruListOriginal[i] = new FRUOriginal((CtStructuredData)ctDataTypeArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "ServiceableEvent.parseFRUListOriginal() expecting CtStructuredData: " + classCastException);
                }
                throw classCastException;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseFRUListOriginal()");
        }
    }

    private void parseFRUListAdditional(McAttribute mcAttribute) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.parseFRUListAdditional()");
        }
        CtDataType[] ctDataTypeArray = ServiceableEvent.getArrayAttributeValue(mcAttribute);
        int n = ctDataTypeArray.length;
        this.fruListAdditional = new FRUAdditional[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.fruListAdditional[i] = new FRUAdditional((CtStructuredData)ctDataTypeArray[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "ServiceableEvent.parseFRUListAdditional() expecting CtStructuredData: " + classCastException);
                }
                throw classCastException;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.parseFRUListAdditional()");
        }
    }

    private static CtDataType[] getArrayAttributeValue(McAttribute mcAttribute) {
        CtDataType[] ctDataTypeArray = ((CtArray)ServiceableEvent.getAttributeValue(mcAttribute)).getData();
        return ctDataTypeArray;
    }

    private static int getIntegerAttributeValue(McAttribute mcAttribute) {
        int n = ((CtUint32)ServiceableEvent.getAttributeValue(mcAttribute)).getJniData();
        return n;
    }

    private static String getStringAttributeValue(McAttribute mcAttribute) {
        String string = ((CtString)ServiceableEvent.getAttributeValue(mcAttribute)).getData();
        return string;
    }

    private static boolean getBooleanAttributeValue(McAttribute mcAttribute) {
        String string = ServiceableEvent.getStringAttributeValue(mcAttribute);
        boolean bl = YES.equalsIgnoreCase(string);
        return bl;
    }

    private static CtStructuredData getStructuredDataAttributeValue(McAttribute mcAttribute) {
        CtStructuredData ctStructuredData = (CtStructuredData)ServiceableEvent.getAttributeValue(mcAttribute);
        return ctStructuredData;
    }

    private static CtRsrcHandle getResourceHandleAttributeValue(McAttribute mcAttribute) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.getResourceHandleAttributeValue()");
        }
        CtRsrcHandle ctRsrcHandle = (CtRsrcHandle)ServiceableEvent.getAttributeValue(mcAttribute);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.getResourceHandleAttributeValue()");
        }
        return ctRsrcHandle;
    }

    private static CtDataType getAttributeValue(McAttribute mcAttribute) {
        if (mcAttribute == null && 2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "ServiceableEvent.getAttributeValue() retrieved a null value");
        }
        CtDataType ctDataType = mcAttribute.getValue();
        return ctDataType;
    }

    public void addListener(ServiceableEventListener serviceableEventListener) {
        if (!this.listeners.contains(serviceableEventListener)) {
            this.listeners.add(serviceableEventListener);
        }
    }

    public void removeListener(ServiceableEventListener serviceableEventListener) {
        this.listeners.remove(serviceableEventListener);
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    private void notifyListeners() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ServiceableEvent.notifyListeners()");
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ServiceableEventListener serviceableEventListener = (ServiceableEventListener)this.listeners.elementAt(i);
            if (serviceableEventListener == null) continue;
            serviceableEventListener.serviceableEventUpdated(this);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-ServiceableEvent.notifyListeners()");
        }
    }
}

